// ##############################################################
//  Bracket.h
//  Magic Number Machine
//
//  Created by Matt Gallagher on Sun May 25 2003.
//  Copyright (c) 2003 Matt Gallagher. All rights reserved.
// ##############################################################

#import <Foundation/Foundation.h>
#import "Expression.h"

//
// About Bracket
//
// A basic node which exists to wrap a sub-tree.
//

@interface Bracket : Expression
{
@protected
	bool	closed;
}
- (id)initWithParent:(Expression*)newParent andManager:(DataManager*)newManager;
- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;
- (void)binaryOpPressed:(int)op;
- (void)closeBracketPressed;
- (void)deleteDigit;
- (void)equalsPressed;
- (NSString*)getExpressionString;
- (NSBezierPath*)pathAtLevel:(int)level;
- (void)postOpPressed:(int)op;

@end
