// ##############################################################
//  CallBack.h
//  Magic Number Machine
//
//  Created by Matt Gallagher on Wed Apr 23 2003.
//  Copyright (c) 2003 Matt Gallagher. All rights reserved.
// ##############################################################

#import <Foundation/Foundation.h>

//
// About CallBack
//
// A small class which creates an object that sends the specified message when it
// is deleted. Useful to have an action called at Autorelease pool time.
//
@interface CallBack : NSObject {
	id		callBackObject;
	SEL	callBackMethod;
}

- (id)initWithObject:(id)object method:(SEL)method;
- (void)dealloc;
+ (id)callBack:(id)object method:(SEL)method;

@end
