// ##############################################################
//  CallBack.m
//  Magic Number Machine
//
//  Created by Matt Gallagher on Wed Apr 23 2003.
//  Copyright (c) 2003 Matt Gallagher. All rights reserved.
// ##############################################################

#import "CallBack.h"

//
// About CallBack
//
// A small class which creates an object that sends the specified message when it
// is deleted. Useful to have an action called at Autorelease pool time.
//
@implementation CallBack

//
// initWithObject
//
// Constructor
//
- (id)initWithObject:(id)object method:(SEL)method
{
	self = [super init];
	if (self)
	{
		callBackObject = object;
		callBackMethod = method;
	}
	return self;
}

//
// dealloc
//
// The destructor is what calls the message
//
- (void)dealloc
{
	[callBackObject performSelector:callBackMethod];
	[super dealloc];
}

//
// callBack
//
// Static method to create the object and autorelease it.
//
+ (id)callBack:(id)object method:(SEL)method
{
	return [[[CallBack alloc] initWithObject:object method:method] autorelease]; 
}

@end
