// ##############################################################
//  PostOp.h
//  Magic Number Machine
//
//  Created by Matt Gallagher on Sun May 25 2003.
//  Copyright (c) 2003 Matt Gallagher. All rights reserved.
// ##############################################################

#import <Foundation/Foundation.h>
#import "Expression.h"

//
// About PostOp
//
// A PostOp is an operator that goes after the number. The two post operations are
// square (x^2) and factorial (x!).
//
// Only minor behaviour changes relative to the inherited functionality  are required
// for this class.
//
@interface PostOp : Expression
{
@protected
	int					op;
}
- (id)initWithParent:(Expression*)newParent manager:(DataManager*)newManager
	child:(Expression*)newChild andOp:(int)newOp;
- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;
- (BigCFloat*)getValue;
- (void)appendOpToPath:(NSBezierPath*)path atLevel:(int)level;
- (NSString*)getExpressionString;
- (NSBezierPath*)pathAtLevel:(int)level;

@end
